/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.auri.AbsoluteUriRecordEncoder;
import org.nfctools.ndef.empty.EmptyRecordEncoder;
import org.nfctools.ndef.ext.ExternalTypeEncoder;
import org.nfctools.ndef.ext.ExternalTypeRecordConfig;
import org.nfctools.ndef.mime.MimeRecordEncoder;
import org.nfctools.ndef.unknown.UnknownRecordEncoder;
import org.nfctools.ndef.unknown.unsupported.UnsupportedRecordEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordConfig;
import org.nfctools.ndef.wkt.WellKnownRecordEncoder;
import org.nfctools.ndef.wkt.encoder.RecordEncoder;

public class NdefRecordEncoder {
    private List<RecordEncoder> knownRecordEncoders = new ArrayList<RecordEncoder>();
    private WellKnownRecordEncoder wellKnownRecordEncoder = new WellKnownRecordEncoder();
    private ExternalTypeEncoder externalTypeEncoder = new ExternalTypeEncoder();

    public NdefRecordEncoder() {
        this.knownRecordEncoders.add(this.wellKnownRecordEncoder);
        this.knownRecordEncoders.add(new MimeRecordEncoder());
        this.knownRecordEncoders.add(new AbsoluteUriRecordEncoder());
        this.knownRecordEncoders.add(this.externalTypeEncoder);
        this.knownRecordEncoders.add(new EmptyRecordEncoder());
        this.knownRecordEncoders.add(new UnknownRecordEncoder());
        this.knownRecordEncoders.add(new UnsupportedRecordEncoder());
    }

    public NdefRecord encode(Record record, NdefMessageEncoder messageEncoder) {
        for (RecordEncoder encoder : this.knownRecordEncoders) {
            if (!encoder.canEncode(record)) continue;
            return encoder.encodeRecord(record, messageEncoder);
        }
        throw new IllegalArgumentException("Unsupported record [" + record.getClass().getName() + "]");
    }

    public void registerWellKnownRecordConfig(WellKnownRecordConfig recordconfig) {
        this.wellKnownRecordEncoder.addRecordConfig(recordconfig);
    }

    public void registerExternalTypeRecordConfig(ExternalTypeRecordConfig recordconfig) {
        this.externalTypeEncoder.addRecordConfig(recordconfig);
    }
}

