/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.auri.AbsoluteUriRecordDecoder;
import org.nfctools.ndef.empty.EmptyRecordDecoder;
import org.nfctools.ndef.ext.ExternalTypeDecoder;
import org.nfctools.ndef.ext.ExternalTypeRecordConfig;
import org.nfctools.ndef.mime.MimeRecordDecoder;
import org.nfctools.ndef.unknown.UnknownRecordDecoder;
import org.nfctools.ndef.unknown.unsupported.UnsupportedRecord;
import org.nfctools.ndef.wkt.WellKnownRecordConfig;
import org.nfctools.ndef.wkt.WellKnownRecordDecoder;
import org.nfctools.ndef.wkt.decoder.RecordDecoder;

public class NdefRecordDecoder {
    private WellKnownRecordDecoder wellKnownRecordDecoder = new WellKnownRecordDecoder();
    private ExternalTypeDecoder externalTypeDecoder = new ExternalTypeDecoder();
    private List<RecordDecoder<? extends Record>> recordDecoders = new ArrayList<RecordDecoder<? extends Record>>();

    public NdefRecordDecoder() {
        this.recordDecoders.add(this.wellKnownRecordDecoder);
        this.recordDecoders.add(new AbsoluteUriRecordDecoder());
        this.recordDecoders.add(new MimeRecordDecoder());
        this.recordDecoders.add(this.externalTypeDecoder);
        this.recordDecoders.add(new EmptyRecordDecoder());
        this.recordDecoders.add(new UnknownRecordDecoder());
    }

    public Record decode(NdefRecord ndefRecord, NdefMessageDecoder messageDecoder) {
        if (ndefRecord.isChunked()) {
            throw new IllegalArgumentException("Cannot decode chunked record");
        }
        for (RecordDecoder<? extends Record> decoder : this.recordDecoders) {
            if (!decoder.canDecode(ndefRecord)) continue;
            return decoder.decodeRecord(ndefRecord, messageDecoder);
        }
        return new UnsupportedRecord(ndefRecord);
    }

    public void registerWellKnownRecordConfig(WellKnownRecordConfig recordconfig) {
        this.wellKnownRecordDecoder.addRecordConfig(recordconfig);
    }

    public void registerExternalTypeRecordConfig(ExternalTypeRecordConfig recordconfig) {
        this.externalTypeDecoder.addRecordConfig(recordconfig);
    }
}

