/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ul;

import org.nfctools.mf.block.MfBlock;

public class UltralightHandler {
    public static boolean isBlank(MfBlock[] blocks) {
        if (blocks.length < 5) {
            throw new IllegalArgumentException("need at least 5 blocks");
        }
        if (blocks[0].getData()[0] == 4 && UltralightHandler.isStaticallyUnlocked(blocks[2].getData()) && UltralightHandler.isOTPClear(blocks[3].getData())) {
            return UltralightHandler.isUltralight(blocks[4].getData()) || UltralightHandler.isUltralightC(blocks[4].getData());
        }
        return false;
    }

    private static boolean isOTPClear(byte[] data) {
        for (int x = 0; x < 4; ++x) {
            if (data[x] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isStaticallyUnlocked(byte[] block) {
        return block[2] == 0 && block[3] == 0;
    }

    public static boolean isUltralight(byte[] block) {
        return UltralightHandler.matchesVersion(block, 255, 255);
    }

    public static boolean isUltralightC(byte[] block) {
        return UltralightHandler.matchesVersion(block, 2, 0);
    }

    private static boolean matchesVersion(byte[] block, int major, int minor) {
        return block[0] == (byte)major && block[1] == (byte)minor;
    }

    public static boolean isFormatted(MfBlock[] blocks) {
        return UltralightHandler.isCapabilityContainerValid(blocks[3].getData());
    }

    private static boolean isCapabilityContainerValid(byte[] block) {
        return block[0] == -31 && block[1] == 16 && block[2] >= 6;
    }
}

