/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ul;

import java.io.IOException;
import org.nfctools.NfcException;
import org.nfctools.api.ApduTag;
import org.nfctools.api.NfcTagListener;
import org.nfctools.api.Tag;
import org.nfctools.api.TagType;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.ul.CapabilityBlock;
import org.nfctools.mf.ul.LockPage;
import org.nfctools.mf.ul.MemoryLayout;
import org.nfctools.mf.ul.MfUlReaderWriter;
import org.nfctools.mf.ul.Type2NdefOperations;
import org.nfctools.mf.ul.UltralightHandler;
import org.nfctools.ndef.NdefOperationsListener;
import org.nfctools.spi.acs.AcrMfUlReaderWriter;

public class Type2NfcTagListener
implements NfcTagListener {
    private NdefOperationsListener ndefListener;

    public Type2NfcTagListener() {
    }

    public Type2NfcTagListener(NdefOperationsListener ndefListener) {
        this.ndefListener = ndefListener;
    }

    public void setNdefListener(NdefOperationsListener ndefListener) {
        this.ndefListener = ndefListener;
    }

    @Override
    public boolean canHandle(Tag tag) {
        return tag.getTagType().equals((Object)TagType.MIFARE_ULTRALIGHT);
    }

    @Override
    public void handleTag(Tag tag) {
        Type2NdefOperations ndefOperations = this.createNdefOperations((ApduTag)((Object)tag));
        if (this.ndefListener != null) {
            this.ndefListener.onNdefOperations(ndefOperations);
        }
    }

    protected Type2NdefOperations createNdefOperations(ApduTag tag) {
        boolean writable;
        boolean formatted;
        MemoryLayout memoryLayout;
        AcrMfUlReaderWriter readerWriter;
        block12: {
            readerWriter = new AcrMfUlReaderWriter(tag);
            memoryLayout = null;
            formatted = false;
            writable = false;
            try {
                MfBlock[] initBlocks = readerWriter.readBlock(0, 5);
                CapabilityBlock capabilityBlock = new CapabilityBlock(initBlocks[3].getData());
                if (UltralightHandler.isBlank(initBlocks)) {
                    if (UltralightHandler.isUltralight(initBlocks[4].getData())) {
                        memoryLayout = MemoryLayout.ULTRALIGHT;
                    } else if (UltralightHandler.isUltralightC(initBlocks[4].getData())) {
                        memoryLayout = MemoryLayout.ULTRALIGHT_C;
                    } else {
                        throw new NfcException("Unknown tag size");
                    }
                    writable = true;
                    break block12;
                }
                if (UltralightHandler.isFormatted(initBlocks)) {
                    formatted = true;
                    if (capabilityBlock.getSize() == 6) {
                        memoryLayout = MemoryLayout.ULTRALIGHT;
                    } else if (capabilityBlock.getSize() == 18) {
                        memoryLayout = MemoryLayout.ULTRALIGHT_C;
                    } else {
                        throw new NfcException("Unknown memory size " + capabilityBlock.getSize());
                    }
                    writable = !capabilityBlock.isReadOnly() && !this.isLocked(readerWriter, memoryLayout);
                    break block12;
                }
                throw new NfcException("Unknown tag contents");
            }
            catch (Exception e) {
                throw new NfcException(e);
            }
        }
        return new Type2NdefOperations(memoryLayout, readerWriter, formatted, writable);
    }

    private boolean isLocked(MfUlReaderWriter readerWriter, MemoryLayout memoryLayout) throws IOException {
        for (LockPage lockPage : memoryLayout.getLockPages()) {
            MfBlock[] block = readerWriter.readBlock(lockPage.getPage(), 1);
            for (byte lockByte : lockPage.getLockBytes()) {
                if (block[0].getData()[lockByte] == 0) continue;
                return true;
            }
        }
        return false;
    }
}

