/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ul;

import java.io.IOException;
import java.util.List;
import org.nfctools.NfcException;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.ndef.AbstractNdefOperations;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.mf.tlv.TypeLengthValueReader;
import org.nfctools.mf.tlv.TypeLengthValueWriter;
import org.nfctools.mf.ul.CapabilityBlock;
import org.nfctools.mf.ul.DataBlock;
import org.nfctools.mf.ul.LockPage;
import org.nfctools.mf.ul.MemoryLayout;
import org.nfctools.mf.ul.MfUlReaderWriter;
import org.nfctools.ndef.Record;
import org.nfctools.tags.TagInputStream;
import org.nfctools.tags.TagOutputStream;

public class Type2NdefOperations
extends AbstractNdefOperations {
    private MemoryLayout memoryLayout;
    private MfUlReaderWriter readerWriter;

    public Type2NdefOperations(MemoryLayout memoryLayout, MfUlReaderWriter readerWriter, boolean formatted, boolean writable) {
        super(formatted, writable);
        this.memoryLayout = memoryLayout;
        this.readerWriter = readerWriter;
    }

    public MemoryLayout getMemoryLayout() {
        return this.memoryLayout;
    }

    @Override
    public int getMaxSize() {
        return this.memoryLayout.getMaxSize();
    }

    @Override
    public List<Record> readNdefMessage() {
        this.assertFormatted();
        if (this.lastReadRecords != null) {
            return this.lastReadRecords;
        }
        TypeLengthValueReader reader = new TypeLengthValueReader(new TagInputStream(this.memoryLayout, this.readerWriter));
        this.convertRecords(reader);
        return this.lastReadRecords;
    }

    @Override
    public void writeNdefMessage(Record ... records) {
        this.lastReadRecords = null;
        this.assertWritable();
        this.assertFormatted();
        byte[] bytes = this.convertNdefMessage(records);
        this.writeBufferOnTag(bytes);
    }

    @Override
    public void makeReadOnly() {
        this.assertWritable();
        this.assertFormatted();
        this.setLockBytes();
        this.writable = false;
    }

    @Override
    public void format(Record ... records) {
        try {
            this.formatCapabilityBlock();
            this.writeNdefMessage(records);
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    private byte[] convertNdefMessage(Record ... records) {
        TagOutputStream out = new TagOutputStream(this.getMaxSize());
        TypeLengthValueWriter writer = new TypeLengthValueWriter(out);
        if (this.memoryLayout.hasDynamicLockBytes()) {
            writer.write(this.memoryLayout.createLockControlTlv());
        }
        writer.write(new NdefMessageTlv(this.convertRecordsToBytes(records)));
        writer.close();
        return out.getBuffer();
    }

    private void writeBufferOnTag(byte[] buffer) {
        this.assertWritable();
        this.assertFormatted();
        try {
            int offset = 0;
            for (int page = this.memoryLayout.getFirstDataPage(); page <= this.memoryLayout.getLastDataPage(); ++page) {
                DataBlock block = new DataBlock(buffer, offset);
                this.readerWriter.writeBlock(page, block);
                offset += this.memoryLayout.getBytesPerPage();
            }
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    private void formatCapabilityBlock() throws IOException {
        this.assertWritable();
        CapabilityBlock block = this.memoryLayout.createCapabilityBlock();
        this.readerWriter.writeBlock(this.memoryLayout.getCapabilityPage(), block);
        this.formatted = true;
    }

    private void setLockBytes() {
        try {
            for (LockPage lockPage : this.memoryLayout.getLockPages()) {
                MfBlock[] block = this.readerWriter.readBlock(lockPage.getPage(), 1);
                for (byte lockByte : lockPage.getLockBytes()) {
                    block[0].getData()[lockByte] = -1;
                }
                this.readerWriter.writeBlock(lockPage.getPage(), block);
            }
            MfBlock[] readBlock = this.readerWriter.readBlock(this.memoryLayout.getCapabilityPage(), 1);
            CapabilityBlock capabilityBlock = new CapabilityBlock(readBlock[0].getData());
            capabilityBlock.setReadOnly();
            this.readerWriter.writeBlock(this.memoryLayout.getCapabilityPage(), capabilityBlock);
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }
}

