/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ul;

import org.nfctools.mf.tlv.LockControlTlv;
import org.nfctools.mf.ul.CapabilityBlock;
import org.nfctools.mf.ul.LockPage;

public class MemoryLayout {
    public static final MemoryLayout ULTRALIGHT = new MemoryLayout(new LockPage[]{new LockPage(2, new byte[]{2, 3})}, 0, 15, 4, 15);
    public static final MemoryLayout ULTRALIGHT_C = new MemoryLayout(new LockPage[]{new LockPage(2, new byte[]{2, 3}), new LockPage(40, new byte[]{0, 1})}, 0, 47, 4, 39);
    private LockPage[] lockPages;
    private int firstPage;
    private int lastPage;
    private int firstDataPage;
    private int lastDataPage;
    private int bytesPerPage = 4;
    private int capabilityPage = 3;
    private boolean dynamicLockBytes;

    private MemoryLayout(LockPage[] lockPages, int firstPage, int lastPage, int firstDataPage, int lastDataPage) {
        this.lockPages = lockPages;
        this.firstPage = firstPage;
        this.lastPage = lastPage;
        this.firstDataPage = firstDataPage;
        this.lastDataPage = lastDataPage;
        this.dynamicLockBytes = lockPages.length > 1;
    }

    public LockPage[] getLockPages() {
        return this.lockPages;
    }

    public int getFirstDataPage() {
        return this.firstDataPage;
    }

    public int getLastDataPage() {
        return this.lastDataPage;
    }

    public int getMaxSize() {
        return (this.lastDataPage - this.firstDataPage + 1) * this.bytesPerPage;
    }

    public int getBytesPerPage() {
        return this.bytesPerPage;
    }

    public int getCapabilityPage() {
        return this.capabilityPage;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public CapabilityBlock createCapabilityBlock() {
        return new CapabilityBlock(16, (byte)(this.getMaxSize() / 8), false);
    }

    public boolean hasDynamicLockBytes() {
        return this.dynamicLockBytes;
    }

    public LockControlTlv createLockControlTlv() {
        if (this.hasDynamicLockBytes()) {
            LockControlTlv tlv = new LockControlTlv();
            tlv.setPageAddress(10);
            tlv.setByteOffset(0);
            tlv.setSize(16);
            tlv.setBytesPerPage(this.bytesPerPage);
            tlv.setBytesLockedPerLockBit(4);
            return tlv;
        }
        return null;
    }
}

