/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tools;

import java.io.IOException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.tools.AbstractCardTool;
import org.nfctools.utils.NfcUtils;

public class MfClassicCardScanner
extends AbstractCardTool {
    @Override
    public void doWithReaderWriter(MfClassicReaderWriter readerWriter) throws IOException {
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        block2: for (int sectorId = 0; sectorId < memoryLayout.getSectors(); ++sectorId) {
            for (byte[] key : this.knownKeys) {
                try {
                    MfClassicAccess access = new MfClassicAccess(new KeyValue(Key.A, key), sectorId, 0, memoryLayout.getBlocksPerSector(sectorId));
                    MfBlock[] mfBlock = readerWriter.readBlock(access);
                    for (int blockId = 0; blockId < mfBlock.length; ++blockId) {
                        System.out.println("S" + sectorId + "|B" + blockId + " Key: " + NfcUtils.convertBinToASCII(key) + " " + mfBlock[blockId]);
                    }
                    continue block2;
                }
                catch (MfLoginException e) {
                    this.log.info("Cannot read sector: " + sectorId + " with key " + NfcUtils.convertBinToASCII(key));
                }
            }
        }
    }
}

