/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tools;

import java.io.IOException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.block.DataBlock;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.tools.AbstractCardTool;
import org.nfctools.utils.NfcUtils;

public class MfClassicCardCleaner
extends AbstractCardTool {
    private TrailerBlock readTrailerBlock(MfClassicReaderWriter readerWriter, int sectorId) throws IOException {
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        for (byte[] key : this.knownKeys) {
            try {
                MfClassicAccess access = new MfClassicAccess(new KeyValue(Key.A, key), sectorId, memoryLayout.getTrailerBlockNumberForSector(sectorId));
                MfBlock[] readBlock = readerWriter.readBlock(access);
                return (TrailerBlock)readBlock[0];
            }
            catch (MfLoginException e) {
            }
        }
        return null;
    }

    @Override
    public void doWithReaderWriter(MfClassicReaderWriter readerWriter) throws IOException {
        DataBlock emptyDataBlock = new DataBlock();
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        block2: for (int sectorId = 0; sectorId < memoryLayout.getSectors(); ++sectorId) {
            TrailerBlock trailerBlock = this.readTrailerBlock(readerWriter, sectorId);
            if (trailerBlock != null) {
                Key keyToWrite = trailerBlock.isKeyBReadable() ? Key.A : Key.B;
                for (byte[] key : this.knownKeys) {
                    try {
                        MfClassicCardCleaner.initTransportConfig(readerWriter, sectorId, new KeyValue(keyToWrite, key));
                        for (int blockId = 0; blockId < memoryLayout.getBlocksPerSector(sectorId); ++blockId) {
                            if (memoryLayout.isTrailerBlock(sectorId, blockId) || blockId == 0 && sectorId == 0) continue;
                            this.log.info("Cleaning S" + sectorId + "|B" + blockId);
                            MfClassicAccess access = new MfClassicAccess(new KeyValue(Key.A, MfConstants.TRANSPORT_KEY), sectorId, blockId);
                            readerWriter.writeBlock(access, emptyDataBlock);
                        }
                        this.log.info("Sector " + sectorId + " clear with key: " + NfcUtils.convertBinToASCII(key));
                        continue block2;
                    }
                    catch (MfLoginException e) {
                        this.log.info("Cannot clear sector: " + sectorId + " with key " + NfcUtils.convertBinToASCII(key));
                    }
                }
                continue;
            }
            this.log.info("Cannot read trailer block in sector: " + sectorId);
        }
        this.log.info("Done!");
    }

    public static void initTransportConfig(MfClassicReaderWriter readerWriter, int sector, KeyValue keyValue) throws IOException {
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        TrailerBlock transportTrailer = new TrailerBlock();
        MfClassicAccess access = new MfClassicAccess(keyValue, sector, memoryLayout.getTrailerBlockNumberForSector(sector));
        readerWriter.writeBlock(access, transportTrailer);
    }
}

