/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.nfctools.api.ApduTag;
import org.nfctools.api.NfcTagListener;
import org.nfctools.api.Tag;
import org.nfctools.api.TagType;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.MadConstants;
import org.nfctools.spi.acs.AcrMfClassicReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCardTool
implements NfcTagListener {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Collection<byte[]> knownKeys = new ArrayList<byte[]>();

    public AbstractCardTool() {
        this.knownKeys.add(MfConstants.NDEF_KEY);
        this.knownKeys.add(MfConstants.TRANSPORT_KEY);
        this.knownKeys.add(MadConstants.DEFAULT_MAD_KEY);
    }

    public void addKnownKey(byte[] key) {
        this.knownKeys.add(key);
    }

    public abstract void doWithReaderWriter(MfClassicReaderWriter var1) throws IOException;

    @Override
    public boolean canHandle(Tag tag) {
        return tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_1K) || tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_4K);
    }

    @Override
    public void handleTag(Tag tag) {
        MemoryLayout memoryLayout = tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_1K) ? MemoryLayout.CLASSIC_1K : MemoryLayout.CLASSIC_4K;
        AcrMfClassicReaderWriter readerWriter = new AcrMfClassicReaderWriter((ApduTag)((Object)tag), memoryLayout);
        try {
            this.doWithReaderWriter(readerWriter);
        }
        catch (IOException e) {
            this.log.error(e.getLocalizedMessage(), e);
        }
    }
}

