/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tlv;

import org.nfctools.mf.tlv.LockControlTlv;
import org.nfctools.mf.tlv.MemoryControlTlv;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.tags.TagOutputStream;

public class TypeLengthValueWriter {
    private TagOutputStream out;

    public TypeLengthValueWriter(TagOutputStream out) {
        this.out = out;
    }

    public void write(LockControlTlv lockControlTlv) {
        this.out.write(1);
        this.writeData(lockControlTlv.toBytes());
    }

    public void write(MemoryControlTlv memoryControlTlv) {
        this.out.write(2);
        this.writeData(memoryControlTlv.toBytes());
    }

    public void write(NdefMessageTlv ndefMessageTlv) {
        byte[] data = ndefMessageTlv.getNdefMessage();
        this.out.write(3);
        this.writeData(data);
    }

    public void writeNullTlv() {
        this.out.write(0);
    }

    private void writeData(byte[] data) {
        if (data.length <= 254) {
            this.out.write(data.length);
        } else if (data.length < 65534) {
            this.out.write(255);
            this.out.write(data.length >>> 8);
            this.out.write(data.length & 0xFF);
        } else {
            throw new IllegalArgumentException("data too long");
        }
        this.out.write(data, 0, data.length);
    }

    public void close() {
        if (this.out.getRemainingSize() > 0) {
            this.out.write(254);
            while (this.out.getRemainingSize() > 0) {
                this.writeNullTlv();
            }
        }
    }
}

