/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tlv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nfctools.mf.tlv.LockControlTlv;
import org.nfctools.mf.tlv.MemoryControlTlv;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.mf.tlv.Tlv;
import org.nfctools.mf.tlv.TlvConstants;

public class TypeLengthValueReader
implements Iterator<Tlv> {
    private InputStream in = null;
    private Tlv nextValue = null;

    public TypeLengthValueReader(InputStream in) {
        this.in = in;
    }

    @Override
    public Tlv next() {
        if (this.nextValue != null) {
            Tlv valueToReturn = this.nextValue;
            this.nextValue = null;
            return valueToReturn;
        }
        try {
            while (this.in.available() > 0) {
                int type = this.in.read();
                while (type == 0 && type != -1) {
                    type = this.in.read();
                }
                if (type == 254) {
                    throw new NoSuchElementException();
                }
                if (TlvConstants.KNOWN_TLVS.contains(type)) {
                    return this.readNextValue(type);
                }
                if (type != 253) continue;
                this.readNextValue(type);
            }
            throw new NoSuchElementException();
        }
        catch (IOException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    private Tlv readNextValue(int type) throws IOException {
        int size = this.in.read();
        if (size == 255) {
            size = this.in.read() << 8 | this.in.read();
        }
        byte[] valueToReturn = new byte[size];
        this.in.read(valueToReturn, 0, size);
        switch (type) {
            case 3: {
                return new NdefMessageTlv(valueToReturn);
            }
            case 1: {
                return new LockControlTlv(valueToReturn);
            }
            case 2: {
                return new MemoryControlTlv(valueToReturn);
            }
            case 253: {
                return null;
            }
        }
        throw new RuntimeException("unkown TLV type " + type + "");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (this.nextValue != null) {
            return true;
        }
        try {
            this.nextValue = this.next();
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }
}

