/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tlv;

import org.nfctools.mf.tlv.AbstractMemoryTlv;
import org.nfctools.utils.NfcUtils;

public class LockControlTlv
extends AbstractMemoryTlv {
    private int bytesLockedPerLockBit;

    public LockControlTlv() {
    }

    public LockControlTlv(byte[] bytes) {
        super(bytes);
        this.bytesLockedPerLockBit = NfcUtils.getMostSignificantNibble(bytes[2]);
    }

    @Override
    public byte[] toBytes() {
        byte[] bytes = super.toBytes();
        bytes[2] = NfcUtils.encodeNibbles(this.bytesLockedPerLockBit, this.bytesPerPage);
        return bytes;
    }

    public int getBytesLockedPerLockBit() {
        return this.bytesLockedPerLockBit;
    }

    public void setBytesLockedPerLockBit(int bytesLockedPerLockBit) {
        this.bytesLockedPerLockBit = bytesLockedPerLockBit;
    }

    public int getSizeInBytes() {
        return (int)Math.ceil(this.getSize() / 8);
    }

    @Override
    public int getSize() {
        return super.getSize();
    }
}

