/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.tlv;

import org.nfctools.mf.tlv.Tlv;
import org.nfctools.utils.NfcUtils;

public class AbstractMemoryTlv
extends Tlv {
    protected int pageAddress;
    protected int byteOffset;
    protected int size;
    protected int bytesPerPage;

    public AbstractMemoryTlv() {
    }

    public AbstractMemoryTlv(byte[] bytes) {
        this.pageAddress = NfcUtils.getMostSignificantNibble(bytes[0]);
        this.byteOffset = NfcUtils.getLeastSignificantNibble(bytes[0]);
        this.size = bytes[1];
        this.bytesPerPage = NfcUtils.getLeastSignificantNibble(bytes[2]);
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{NfcUtils.encodeNibbles(this.pageAddress, this.byteOffset), (byte)this.size, NfcUtils.encodeNibbles(0, this.bytesPerPage)};
        return bytes;
    }

    public int getPosition() {
        return Math.round(this.pageAddress * (int)Math.pow(2.0, this.bytesPerPage) + this.byteOffset);
    }

    public int getPageAddress() {
        return this.pageAddress;
    }

    public void setPageAddress(int pageAddress) {
        this.pageAddress = pageAddress;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public int getBytesPerPage() {
        return this.bytesPerPage;
    }

    public void setBytesPerPage(int bytesPerPage) {
        this.bytesPerPage = bytesPerPage;
    }

    public int getSize() {
        if (this.size == 0) {
            return 256;
        }
        return this.size;
    }

    public void setSize(int size) {
        if (size == 256) {
            size = 0;
        } else {
            this.size = size;
        }
    }
}

