/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ndef;

import java.io.IOException;
import java.util.List;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.MadUtils;
import org.nfctools.mf.ndef.MfNdefConstants;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.mf.tlv.TypeLengthValueWriter;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.NdefWriter;
import org.nfctools.ndef.Record;
import org.nfctools.tags.TagOutputStream;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MfNdefWriter
implements NdefWriter<MfCard> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MfReaderWriter readerWriter;
    private NdefMessageEncoder ndefMessageEncoder;
    private Key createKey = Key.A;
    private byte[] createKeyValue = MfConstants.TRANSPORT_KEY;
    private byte[] writeKeyValue = MfConstants.NDEF_KEY;
    private byte[] deleteKeyValue = MfConstants.NDEF_KEY;

    public MfNdefWriter(MfReaderWriter readerWriter, NdefMessageEncoder ndefMessageEncoder) {
        this.readerWriter = readerWriter;
        this.ndefMessageEncoder = ndefMessageEncoder;
    }

    public void setCreateKey(Key createKey) {
        this.createKey = createKey;
    }

    public void setWriteKeyValue(byte[] writeKeyValue) {
        this.writeKeyValue = writeKeyValue;
    }

    public void setDeleteKeyValue(byte[] deleteKeyValue) {
        this.deleteKeyValue = deleteKeyValue;
    }

    @Override
    public void writeNdefMessage(MfCard card, List<Record> records) throws IOException {
        byte[] ndefData = this.ndefMessageEncoder.encode(records);
        this.writeNdefMessage(card, ndefData);
    }

    private void writeNdefMessage(MfCard card, byte[] ndefData) throws IOException, MfException {
        ApplicationDirectory applicationDirectory = null;
        applicationDirectory = MadUtils.hasApplicationDirectory(card, this.readerWriter) ? MadUtils.getApplicationDirectory(card, this.readerWriter, this.writeKeyValue) : MadUtils.createApplicationDirectory(card, this.readerWriter, this.createKey, this.createKeyValue, this.writeKeyValue);
        TrailerBlock trailerBlock = this.createNdefTrailerBlock();
        if (applicationDirectory.hasApplication(MfNdefConstants.NDEF_APP_ID)) {
            applicationDirectory.deleteApplication(MfNdefConstants.NDEF_APP_ID, this.deleteKeyValue, new TrailerBlock());
        }
        byte[] tlvWrappedNdefData = this.wrapNdefMessageWithTlv(ndefData, applicationDirectory.getMaxContinousSize());
        Application application = applicationDirectory.createApplication(MfNdefConstants.NDEF_APP_ID, tlvWrappedNdefData.length, this.writeKeyValue, trailerBlock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Length: " + tlvWrappedNdefData.length + " [" + NfcUtils.convertBinToASCII(tlvWrappedNdefData) + "]");
        }
        application.write(new KeyValue(Key.B, this.writeKeyValue), tlvWrappedNdefData);
    }

    private TrailerBlock createNdefTrailerBlock() throws MfException {
        TrailerBlock trailerBlock = new TrailerBlock();
        trailerBlock.setKey(Key.A, MfConstants.NDEF_KEY);
        trailerBlock.setKey(Key.B, this.writeKeyValue);
        trailerBlock.setAccessConditions(MfConstants.NDEF_READ_WRITE_ACCESS_CONDITIONS);
        trailerBlock.setGeneralPurposeByte((byte)64);
        return trailerBlock;
    }

    private byte[] wrapNdefMessageWithTlv(byte[] ndefMessage, int maxSize) {
        TagOutputStream out = new TagOutputStream(maxSize);
        TypeLengthValueWriter writer = new TypeLengthValueWriter(out);
        writer.write(new NdefMessageTlv(ndefMessage));
        writer.close();
        return out.getBuffer();
    }
}

