/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.ndef;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.MadUtils;
import org.nfctools.mf.ndef.MfNdefConstants;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.mf.tlv.Tlv;
import org.nfctools.mf.tlv.TypeLengthValueReader;
import org.nfctools.ndef.NdefException;
import org.nfctools.ndef.NdefMessage;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.NdefReader;
import org.nfctools.ndef.Record;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MfNdefReader
implements NdefReader<MfCard> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MfReaderWriter readerWriter;
    private NdefMessageDecoder ndefMessageDecoder;

    public MfNdefReader(MfReaderWriter readerWriter, NdefMessageDecoder ndefMessageDecoder) {
        this.readerWriter = readerWriter;
        this.ndefMessageDecoder = ndefMessageDecoder;
    }

    @Override
    public List<Record> readNdefMessage(MfCard card) throws IOException {
        if (!MadUtils.hasApplicationDirectory(card, this.readerWriter)) {
            throw new NdefException("unknown service type");
        }
        ApplicationDirectory applicationDirectory = MadUtils.getApplicationDirectory(card, this.readerWriter);
        if (applicationDirectory.hasApplication(MfNdefConstants.NDEF_APP_ID)) {
            Application application = applicationDirectory.openApplication(MfNdefConstants.NDEF_APP_ID);
            byte[] tlvWrappedNdefMessage = application.read(new KeyValue(Key.A, MfConstants.NDEF_KEY));
            if (this.log.isDebugEnabled()) {
                this.log.debug(NfcUtils.convertBinToASCII(tlvWrappedNdefMessage));
            }
            TypeLengthValueReader lengthValueReader = new TypeLengthValueReader(new ByteArrayInputStream(tlvWrappedNdefMessage));
            ArrayList<Record> records = new ArrayList<Record>();
            while (lengthValueReader.hasNext()) {
                Tlv tlv = lengthValueReader.next();
                if (!(tlv instanceof NdefMessageTlv)) continue;
                NdefMessage ndefMessage = this.ndefMessageDecoder.decode(((NdefMessageTlv)tlv).getNdefMessage());
                for (Record record : this.ndefMessageDecoder.decodeToRecords(ndefMessage)) {
                    records.add(record);
                }
            }
            return records;
        }
        throw new NdefException("unknown service type");
    }
}

