/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.mad;

import java.io.IOException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.Mad1;
import org.nfctools.mf.mad.MadKeyConfig;

public class Mad2
extends Mad1 {
    protected byte[] mad2Data = new byte[48];
    private TrailerBlock trailerBlock;
    private final int mad2sectorId = 16;

    Mad2(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig) throws IOException {
        super(readerWriter, keyConfig);
    }

    Mad2(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig, TrailerBlock trailerBlock) throws IOException {
        super(readerWriter, keyConfig, trailerBlock);
        this.trailerBlock = trailerBlock.clone();
        this.trailerBlock.setGeneralPurposeByte((byte)0);
    }

    @Override
    public void initMadTrailer(int madVersion) throws MfException, IOException {
        super.initMadTrailer(madVersion);
        this.trailerBlock = this.createTrailer(this.keyConfig.getWriteKeyValue());
        this.trailerBlock.setGeneralPurposeByte((byte)0);
        MfClassicAccess accessTrailer = new MfClassicAccess(new KeyValue(this.keyConfig.getCreateKey(), this.keyConfig.getCreateKeyValue()), 16, this.memoryLayout.getTrailerBlockNumberForSector(16));
        this.readerWriter.writeBlock(accessTrailer, this.trailerBlock);
    }

    @Override
    public void makeReadOnly() throws IOException {
        super.makeReadOnly();
        this.trailerBlock.setAccessConditions(MfConstants.NDEF_READ_ONLY_ACCESS_CONDITIONS);
        this.writeTrailer(16, this.trailerBlock);
    }

    @Override
    protected void updateCrc() {
        super.updateCrc();
        this.mad2Data[0] = this.createCrc(this.mad2Data);
    }

    @Override
    public void readMad() throws IOException {
        super.readMad();
        this.readMad(this.mad2Data, 16, 0, this.trailerBlock);
    }

    @Override
    public void writeMad() throws IOException {
        super.writeMad();
        this.writeMad(this.mad2Data, 16, 0, this.trailerBlock);
    }

    @Override
    protected byte[] getAid(int aidSlot) {
        if (aidSlot < super.getNumberOfSlots()) {
            return super.getAid(aidSlot);
        }
        if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
            throw new IllegalArgumentException("aid slot out of range");
        }
        return new byte[]{this.mad2Data[(aidSlot - 15) * 2 + 2], this.mad2Data[(aidSlot - 15) * 2 + 3]};
    }

    @Override
    protected void setAid(int aidSlot, byte[] aid) {
        if (aidSlot < super.getNumberOfSlots()) {
            super.setAid(aidSlot, aid);
        } else {
            if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
                throw new IllegalArgumentException("aid slot out of range");
            }
            this.mad2Data[(aidSlot - 15) * 2 + 2] = aid[0];
            this.mad2Data[(aidSlot - 15) * 2 + 3] = aid[1];
            this.updateCrc();
        }
    }

    @Override
    public int getNumberOfSlots() {
        return 38;
    }

    @Override
    protected int getSlotSize(int aidSlot) {
        if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
            throw new IllegalArgumentException("aid slot out of range");
        }
        if (aidSlot < 30) {
            return super.getSlotSize(aidSlot);
        }
        return 240;
    }

    @Override
    protected int getSectorIdForSlot(int slot) {
        if (slot < 15) {
            return super.getSectorIdForSlot(slot);
        }
        return slot + 2;
    }
}

