/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.mad;

import java.io.IOException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.AbstractMad;
import org.nfctools.mf.mad.MadConstants;
import org.nfctools.mf.mad.MadKeyConfig;

public class Mad1
extends AbstractMad {
    protected byte[] madData = new byte[32];
    private TrailerBlock trailerBlock;
    private final int mad1SectorId = 0;

    Mad1(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig) throws IOException {
        super(readerWriter, keyConfig);
    }

    Mad1(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig, TrailerBlock trailerBlock) throws IOException {
        super(readerWriter, keyConfig);
        this.trailerBlock = trailerBlock;
    }

    public void initMadTrailer(int madVersion) throws IOException {
        this.trailerBlock = this.createTrailer(this.keyConfig.getWriteKeyValue());
        this.trailerBlock.setGeneralPurposeByte((byte)(0xC0 | madVersion));
        this.writeTrailer(0, this.trailerBlock);
    }

    protected TrailerBlock createTrailer(byte[] writeKeyValue) throws MfException {
        TrailerBlock trailerBlock = new TrailerBlock();
        trailerBlock.setKey(Key.A, MadConstants.DEFAULT_MAD_KEY);
        trailerBlock.setKey(Key.B, writeKeyValue);
        trailerBlock.setAccessConditions(MadConstants.READ_WRITE_ACCESS_CONDITIONS);
        return trailerBlock;
    }

    @Override
    public void readMad() throws IOException {
        this.readMad(this.madData, 0, 1, this.trailerBlock);
    }

    @Override
    public void writeMad() throws IOException {
        this.updateCrc();
        this.writeMad(this.madData, 0, 1, this.trailerBlock);
    }

    @Override
    public void makeReadOnly() throws IOException {
        this.trailerBlock.setAccessConditions(MfConstants.NDEF_READ_ONLY_ACCESS_CONDITIONS);
        this.writeTrailer(0, this.trailerBlock);
    }

    protected void updateCrc() {
        if (this.isReadonly()) {
            throw new IllegalStateException("cannot modify readonly mad");
        }
        this.madData[0] = this.createCrc(this.madData);
    }

    @Override
    protected byte[] getAid(int aidSlot) {
        if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
            throw new IllegalArgumentException("aid slot out of range");
        }
        return new byte[]{this.madData[aidSlot * 2 + 2], this.madData[aidSlot * 2 + 3]};
    }

    @Override
    protected void setAid(int aidSlot, byte[] aid) {
        if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
            throw new IllegalArgumentException("aid slot out of range");
        }
        this.madData[aidSlot * 2 + 2] = aid[0];
        this.madData[aidSlot * 2 + 3] = aid[1];
        this.updateCrc();
    }

    @Override
    protected int getSectorIdForSlot(int slot) {
        return slot + 1;
    }

    @Override
    protected int getSlotSize(int aidSlot) {
        if (aidSlot < 0 || aidSlot >= this.getNumberOfSlots()) {
            throw new IllegalArgumentException("aid slot out of range");
        }
        return 48;
    }

    @Override
    public int getGeneralPurposeByte() {
        return this.trailerBlock.getGeneralPurposeByte();
    }

    @Override
    public int getInfoByte() {
        return this.madData[1];
    }

    @Override
    public int getMaxContinousSize() {
        return this.getMaxContinousSpaceForAid((byte[])Mad1.FREE_SLOT).continousSize;
    }

    @Override
    public int getVersion() {
        return this.getGeneralPurposeByte() & 3;
    }

    @Override
    public boolean isFree(int aidSlot) {
        byte[] aid = this.getAid(aidSlot);
        return aid[0] == 0 && aid[1] == 0;
    }

    @Override
    public int getNumberOfSlots() {
        return 15;
    }
}

