/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.mad;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.nfctools.NfcException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.block.DataBlock;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.AbstractMad;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.ApplicationId;

public class ApplicationImpl
implements Application {
    private ApplicationId applicationId;
    private MemoryLayout memoryLayout;
    private MfClassicReaderWriter readerWriter;
    private int firstSlot;
    private int lastSlot;
    private int allocatedSize;
    private AbstractMad mad;
    private TrailerBlock trailerBlock;

    public ApplicationImpl(ApplicationId applicationId, int allocatedSize, MfClassicReaderWriter readerWriter, int firstSlot, int lastSlot, AbstractMad mad) {
        this.applicationId = applicationId;
        this.allocatedSize = allocatedSize;
        this.readerWriter = readerWriter;
        this.firstSlot = firstSlot;
        this.lastSlot = lastSlot;
        this.mad = mad;
        this.memoryLayout = readerWriter.getMemoryLayout();
    }

    @Override
    public byte[] getApplicationId() {
        return this.applicationId.getAid();
    }

    @Override
    public int getAllocatedSize() {
        return this.allocatedSize;
    }

    @Override
    public byte[] read(KeyValue keyValue) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.allocatedSize);
        for (int slot = this.firstSlot; slot <= this.lastSlot; ++slot) {
            int sectorId = this.mad.getSectorIdForSlot(slot);
            try {
                this.readBlockData(keyValue, baos, sectorId);
                continue;
            }
            catch (MfLoginException e) {
                this.readBlockData(new KeyValue(keyValue.getKey(), MfConstants.TRANSPORT_KEY), baos, sectorId);
            }
        }
        return baos.toByteArray();
    }

    private void readBlockData(KeyValue keyValue, ByteArrayOutputStream baos, int sectorId) throws IOException {
        MfBlock[] blocks;
        MfClassicAccess access = new MfClassicAccess(keyValue, sectorId, 0, this.memoryLayout.getDataBlocksPerSector(sectorId));
        for (MfBlock block : blocks = this.readerWriter.readBlock(access)) {
            baos.write(block.getData());
        }
    }

    @Override
    public void write(KeyValue keyValue, byte[] content) throws IOException {
        if (content.length <= this.getAllocatedSize()) {
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            for (int slot = this.firstSlot; slot <= this.lastSlot; ++slot) {
                int sectorId = this.mad.getSectorIdForSlot(slot);
                for (int blockId = 0; blockId < this.memoryLayout.getDataBlocksPerSector(sectorId); ++blockId) {
                    MfClassicAccess access = new MfClassicAccess(keyValue, sectorId, blockId);
                    byte[] buffer = new byte[16];
                    if (bais.available() > 0) {
                        bais.read(buffer);
                    }
                    DataBlock dataBlock = new DataBlock(buffer);
                    this.readerWriter.writeBlock(access, dataBlock);
                }
            }
        } else {
            throw new IllegalArgumentException("content length too big for allocated space");
        }
    }

    @Override
    public void updateTrailer(KeyValue keyValue, TrailerBlock trailerBlock) throws IOException {
        for (int slot = this.firstSlot; slot <= this.lastSlot; ++slot) {
            int sectorId = this.mad.getSectorIdForSlot(slot);
            MfClassicAccess access = new MfClassicAccess(keyValue, sectorId, this.memoryLayout.getTrailerBlockNumberForSector(sectorId));
            this.readerWriter.writeBlock(access, trailerBlock);
        }
        this.trailerBlock = trailerBlock;
    }

    @Override
    public TrailerBlock readTrailer(KeyValue keyValue) throws IOException {
        if (this.trailerBlock == null) {
            for (int slot = this.firstSlot; slot <= this.lastSlot; ++slot) {
                int sectorId = this.mad.getSectorIdForSlot(slot);
                MfClassicAccess access = new MfClassicAccess(keyValue, sectorId, this.memoryLayout.getTrailerBlockNumberForSector(sectorId));
                TrailerBlock block = (TrailerBlock)this.readerWriter.readBlock(access)[0];
                if (this.trailerBlock == null) {
                    this.trailerBlock = block;
                    continue;
                }
                if (Arrays.equals(block.getAccessConditions(), this.trailerBlock.getAccessConditions()) && block.getGeneralPurposeByte() == this.trailerBlock.getGeneralPurposeByte()) continue;
                throw new NfcException("Not all trailer blocks are equal for the APP-ID. Somebody tempered with the tag.");
            }
        }
        return this.trailerBlock;
    }

    @Override
    public void makeReadOnly(KeyValue keyValue) throws IOException {
        this.readTrailer(keyValue);
        this.trailerBlock.setAccessConditions(MfConstants.NDEF_READ_ONLY_ACCESS_CONDITIONS);
        this.trailerBlock.setGeneralPurposeByte((byte)67);
        this.updateTrailer(keyValue, this.trailerBlock);
    }

    @Override
    public ApplicationDirectory getApplicationDirectory() {
        return this.mad;
    }
}

