/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.mad;

import java.io.IOException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.NxpCrc;
import org.nfctools.mf.block.DataBlock;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicConstants;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.ApplicationId;
import org.nfctools.mf.mad.ApplicationImpl;
import org.nfctools.mf.mad.Mad1;
import org.nfctools.mf.mad.Mad2;
import org.nfctools.mf.mad.MadConstants;
import org.nfctools.mf.mad.MadKeyConfig;

public abstract class AbstractMad
implements ApplicationDirectory {
    protected static final byte[] FREE_SLOT = new byte[]{0, 0};
    protected MadKeyConfig keyConfig;
    protected MemoryLayout memoryLayout;
    protected MfClassicReaderWriter readerWriter;
    private boolean readonly;

    public AbstractMad(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig) {
        if (keyConfig == null) {
            throw new IllegalArgumentException("keyConfig cannot be null");
        }
        this.readerWriter = readerWriter;
        this.keyConfig = keyConfig;
        this.memoryLayout = readerWriter.getMemoryLayout();
    }

    protected void readMad(byte[] madData, int sectorId, int firstBlockId, TrailerBlock trailerBlock) throws IOException {
        int blocksToRead = madData.length / 16;
        MfClassicAccess access = new MfClassicAccess(new KeyValue(Key.A, trailerBlock.getKey(Key.A)), sectorId, firstBlockId, blocksToRead);
        MfBlock[] madBlocks = this.readerWriter.readBlock(access);
        for (int x = 0; x < blocksToRead; ++x) {
            System.arraycopy(madBlocks[x].getData(), 0, madData, x * 16, 16);
        }
    }

    protected void writeMad(byte[] madData, int sectorId, int firstBlockId, TrailerBlock trailerBlock) throws IOException {
        int blocksToWrite = madData.length / 16;
        MfBlock[] dataBlocks = new DataBlock[blocksToWrite];
        for (int x = 0; x < blocksToWrite; ++x) {
            byte[] writeBuffer = new byte[16];
            System.arraycopy(madData, x * 16, writeBuffer, 0, 16);
            dataBlocks[x] = new DataBlock(writeBuffer);
        }
        MfClassicAccess access = new MfClassicAccess(new KeyValue(Key.B, trailerBlock.getKey(Key.B)), sectorId, firstBlockId);
        this.readerWriter.writeBlock(access, dataBlocks);
    }

    protected byte createCrc(byte[] madData) {
        if (this.isReadonly()) {
            throw new IllegalStateException("cannot modify readonly mad");
        }
        NxpCrc crc = new NxpCrc();
        for (int x = 1; x < madData.length; ++x) {
            crc.add(madData[x]);
        }
        return crc.getCrc();
    }

    protected void writeTrailer(int trailerSectorId, TrailerBlock trailerBlock) throws IOException {
        MfClassicAccess accessTrailer = new MfClassicAccess(new KeyValue(this.keyConfig.getCreateKey(), this.keyConfig.getCreateKeyValue()), trailerSectorId, this.memoryLayout.getTrailerBlockNumberForSector(trailerSectorId));
        this.readerWriter.writeBlock(accessTrailer, trailerBlock);
    }

    public void setReadonly() {
        this.readonly = true;
    }

    protected abstract int getSectorIdForSlot(int var1);

    protected abstract int getSlotSize(int var1);

    protected abstract void setAid(int var1, byte[] var2);

    protected abstract byte[] getAid(int var1);

    protected abstract void readMad() throws IOException;

    protected abstract void writeMad() throws IOException;

    protected Space getMaxContinousSpaceForAid(byte[] aid) {
        Space maxContinousSpace = new Space();
        int localMax = 0;
        int possibleFirstSlot = 0;
        for (int slot = 0; slot < this.getNumberOfSlots(); ++slot) {
            byte[] slotAid = this.getAid(slot);
            if (slotAid[0] == aid[0] && slotAid[1] == aid[1]) {
                maxContinousSpace.firstSlot = possibleFirstSlot;
                maxContinousSpace.continousSize = Math.max(localMax += this.getSlotSize(slot), maxContinousSpace.continousSize);
                maxContinousSpace.lastSlot = slot;
                continue;
            }
            possibleFirstSlot = slot + 1;
            localMax = 0;
        }
        return maxContinousSpace;
    }

    @Override
    public Application openApplication(ApplicationId aId) {
        Space space = this.getMaxContinousSpaceForAid(aId.getAid());
        if (space.continousSize > 0) {
            return new ApplicationImpl(aId, space.continousSize, this.readerWriter, space.firstSlot, space.lastSlot, this);
        }
        throw new IllegalArgumentException("aid not available");
    }

    @Override
    public void deleteApplication(ApplicationId aId, byte[] writeKeyValue, TrailerBlock trailerBlock) throws IOException {
        if (this.isReadonly()) {
            throw new IllegalStateException("cannot modify readonly mad");
        }
        Space space = this.getMaxContinousSpaceForAid(aId.getAid());
        for (int slot = space.firstSlot; slot <= space.lastSlot; ++slot) {
            int sectorId = this.getSectorIdForSlot(slot);
            this.writeBlock(Key.B, writeKeyValue, trailerBlock, sectorId);
            this.setAid(slot, FREE_SLOT);
        }
        this.writeMad();
    }

    @Override
    public Application createApplication(ApplicationId aId, int sizeToAllocate, byte[] writeKeyValue, TrailerBlock trailerBlock) throws IOException {
        if (this.isReadonly()) {
            throw new IllegalStateException("cannot modify readonly mad");
        }
        if (sizeToAllocate <= 0) {
            throw new IllegalArgumentException("cannot create an empty application");
        }
        Space space = this.getMaxContinousSpaceForAid(FREE_SLOT);
        if (sizeToAllocate <= space.continousSize) {
            int allocatedSize;
            int slot;
            int lastSlotAllocated = slot = space.firstSlot;
            for (allocatedSize = 0; allocatedSize < sizeToAllocate && slot <= space.lastSlot; allocatedSize += this.getSlotSize(slot)) {
                int sectorId = this.getSectorIdForSlot(slot);
                try {
                    this.writeBlock(Key.B, writeKeyValue, trailerBlock, sectorId);
                }
                catch (MfLoginException e) {
                    this.writeBlock(Key.A, MfConstants.TRANSPORT_KEY, trailerBlock, sectorId);
                }
                this.setAid(slot, aId.getAid());
                lastSlotAllocated = slot++;
            }
            this.writeMad();
            return new ApplicationImpl(aId, allocatedSize, this.readerWriter, space.firstSlot, lastSlotAllocated, this);
        }
        throw new IllegalArgumentException("not enough space (" + space.continousSize + ")");
    }

    private void writeBlock(Key writeKey, byte[] writeKeyValue, TrailerBlock trailerBlock, int sectorId) throws IOException {
        MfClassicAccess access = new MfClassicAccess(new KeyValue(writeKey, writeKeyValue), sectorId, this.memoryLayout.getTrailerBlockNumberForSector(sectorId));
        this.readerWriter.writeBlock(access, trailerBlock);
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public boolean hasApplication(ApplicationId aId) throws IOException {
        Space space = this.getMaxContinousSpaceForAid(aId.getAid());
        return space.continousSize > 0;
    }

    public static ApplicationDirectory initInstance(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig) throws IOException {
        byte[] writeKeyValue = keyConfig == null ? null : keyConfig.getWriteKeyValue();
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        MfClassicAccess accessTrailer = new MfClassicAccess(MfClassicConstants.MAD_KEY, 0, memoryLayout.getTrailerBlockNumberForSector(0));
        TrailerBlock madTrailer = (TrailerBlock)readerWriter.readBlock(accessTrailer)[0];
        if ((madTrailer.getGeneralPurposeByte() & 0x80) != 0) {
            if ((madTrailer.getGeneralPurposeByte() & 1) == 1) {
                madTrailer.setKey(Key.A, MadConstants.DEFAULT_MAD_KEY);
                if (writeKeyValue != null) {
                    madTrailer.setKey(Key.B, writeKeyValue);
                }
                Mad1 mad1 = new Mad1(readerWriter, keyConfig, madTrailer);
                mad1.readMad();
                if (writeKeyValue == null) {
                    mad1.setReadonly();
                }
                return mad1;
            }
            if ((madTrailer.getGeneralPurposeByte() & 2) == 2) {
                madTrailer.setKey(Key.A, MadConstants.DEFAULT_MAD_KEY);
                if (writeKeyValue != null) {
                    madTrailer.setKey(Key.B, writeKeyValue);
                }
                Mad2 mad = new Mad2(readerWriter, keyConfig, madTrailer);
                mad.readMad();
                if (writeKeyValue == null) {
                    mad.setReadonly();
                }
                return mad;
            }
            throw new MfException("MAD version not supported");
        }
        throw new MfException("MAD not available");
    }

    public static ApplicationDirectory createInstance(MfClassicReaderWriter readerWriter, MadKeyConfig keyConfig) throws IOException {
        MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
        if (memoryLayout.getMadVersion() == 1) {
            Mad1 mad1 = new Mad1(readerWriter, keyConfig);
            mad1.initMadTrailer(memoryLayout.getMadVersion());
            mad1.writeMad();
            return mad1;
        }
        if (memoryLayout.getMadVersion() == 2) {
            Mad2 mad2 = new Mad2(readerWriter, keyConfig);
            mad2.initMadTrailer(memoryLayout.getMadVersion());
            mad2.writeMad();
            return mad2;
        }
        throw new RuntimeException("Unsupported MAD version" + memoryLayout.getMadVersion());
    }

    protected class Space {
        int firstSlot;
        int lastSlot;
        int continousSize;

        protected Space() {
        }
    }
}

