/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.classic;

import java.io.IOException;
import org.nfctools.NfcException;
import org.nfctools.api.ApduTag;
import org.nfctools.api.NfcTagListener;
import org.nfctools.api.Tag;
import org.nfctools.api.TagType;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.classic.ClassicHandler;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicConstants;
import org.nfctools.mf.classic.MfClassicNdefOperations;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.ndef.NdefOperationsListener;
import org.nfctools.spi.acs.AcrMfClassicReaderWriter;

public class MfClassicNfcTagListener
implements NfcTagListener {
    private NdefOperationsListener ndefListener;

    public MfClassicNfcTagListener() {
    }

    public MfClassicNfcTagListener(NdefOperationsListener ndefListener) {
        this.ndefListener = ndefListener;
    }

    @Override
    public boolean canHandle(Tag tag) {
        return tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_1K) || tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_4K);
    }

    @Override
    public void handleTag(Tag tag) {
        MemoryLayout memoryLayout = tag.getTagType().equals((Object)TagType.MIFARE_CLASSIC_1K) ? MemoryLayout.CLASSIC_1K : MemoryLayout.CLASSIC_4K;
        MfClassicNdefOperations ndefOperations = this.createNdefOperations((ApduTag)((Object)tag), memoryLayout);
        if (this.ndefListener != null) {
            this.ndefListener.onNdefOperations(ndefOperations);
        }
    }

    protected MfClassicNdefOperations createNdefOperations(ApduTag tag, MemoryLayout memoryLayout) {
        AcrMfClassicReaderWriter readerWriter;
        boolean writable;
        boolean formatted;
        block5: {
            formatted = false;
            writable = false;
            readerWriter = new AcrMfClassicReaderWriter(tag, memoryLayout);
            try {
                if (readerWriter.hasApplicationDirectory()) {
                    ApplicationDirectory applicationDirectory = readerWriter.getApplicationDirectory();
                    if (applicationDirectory.hasApplication(MfConstants.NDEF_APP_ID)) {
                        formatted = true;
                        Application application = applicationDirectory.openApplication(MfConstants.NDEF_APP_ID);
                        writable = ClassicHandler.isFormattedWritable(application, MfClassicConstants.NDEF_KEY);
                        break block5;
                    }
                    throw new NfcException("Unknown tag contents");
                }
                if (ClassicHandler.isBlank(readerWriter)) {
                    writable = true;
                    break block5;
                }
                throw new NfcException("Unknown tag contents");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new MfClassicNdefOperations(readerWriter, formatted, writable);
    }
}

