/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.classic;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.nfctools.NfcException;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.ClassicHandler;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.Application;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.MadKeyConfig;
import org.nfctools.mf.ndef.AbstractNdefOperations;
import org.nfctools.mf.tlv.NdefMessageTlv;
import org.nfctools.mf.tlv.TypeLengthValueReader;
import org.nfctools.mf.tlv.TypeLengthValueWriter;
import org.nfctools.ndef.Record;
import org.nfctools.tags.TagOutputStream;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MfClassicNdefOperations
extends AbstractNdefOperations {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MfClassicReaderWriter readerWriter;
    private byte[] writeKey = MfConstants.NDEF_KEY;

    public MfClassicNdefOperations(MfClassicReaderWriter readerWriter, boolean formatted, boolean writeable) {
        super(formatted, writeable);
        this.readerWriter = readerWriter;
    }

    @Override
    public int getMaxSize() {
        this.assertFormatted();
        return this.getApplication().getAllocatedSize();
    }

    @Override
    public List<Record> readNdefMessage() {
        this.assertFormatted();
        if (this.lastReadRecords != null) {
            return this.lastReadRecords;
        }
        try {
            Application application = this.getApplication();
            byte[] tlvWrappedNdefMessage = application.read(new KeyValue(Key.A, MfConstants.NDEF_KEY));
            if (this.log.isDebugEnabled()) {
                this.log.debug(NfcUtils.convertBinToASCII(tlvWrappedNdefMessage));
            }
            TypeLengthValueReader reader = new TypeLengthValueReader(new ByteArrayInputStream(tlvWrappedNdefMessage));
            this.convertRecords(reader);
            return this.lastReadRecords;
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    private Application getApplication() {
        try {
            ApplicationDirectory applicationDirectory = this.readerWriter.getApplicationDirectory(new MadKeyConfig(Key.A, this.writeKey, this.writeKey));
            Application application = applicationDirectory.openApplication(MfConstants.NDEF_APP_ID);
            return application;
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    @Override
    public void writeNdefMessage(Record ... records) {
        this.assertWritable();
        this.assertFormatted();
        this.writeRecord(this.getApplication(), records);
    }

    @Override
    public void makeReadOnly() {
        this.assertFormatted();
        this.assertWritable();
        try {
            Application application = this.getApplication();
            application.getApplicationDirectory().makeReadOnly();
            application.makeReadOnly(new KeyValue(Key.B, this.writeKey));
            this.writable = false;
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    @Override
    public void format(Record ... records) {
        Application application = this.createNewApplication();
        this.writeRecord(application, records);
        this.formatted = true;
    }

    private Application createNewApplication() {
        try {
            ApplicationDirectory applicationDirectory = this.readerWriter.createApplicationDirectory(new MadKeyConfig(Key.A, MfConstants.TRANSPORT_KEY, this.writeKey));
            TrailerBlock readWriteTrailerBlock = ClassicHandler.createReadWriteDataTrailerBlock();
            readWriteTrailerBlock.setKey(Key.A, this.writeKey);
            readWriteTrailerBlock.setKey(Key.B, this.writeKey);
            Application application = applicationDirectory.createApplication(MfConstants.NDEF_APP_ID, applicationDirectory.getMaxContinousSize(), this.writeKey, readWriteTrailerBlock);
            return application;
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    private void writeRecord(Application application, Record ... records) {
        try {
            byte[] tlvWrappedNdefData = this.wrapNdefMessageWithTlv(this.convertRecordsToBytes(records), application.getAllocatedSize());
            application.write(new KeyValue(Key.B, this.writeKey), tlvWrappedNdefData);
        }
        catch (IOException e) {
            throw new NfcException(e);
        }
    }

    private byte[] wrapNdefMessageWithTlv(byte[] ndefMessage, int maxSize) {
        TagOutputStream out = new TagOutputStream(maxSize);
        TypeLengthValueWriter writer = new TypeLengthValueWriter(out);
        writer.write(new NdefMessageTlv(ndefMessage));
        writer.close();
        return out.getBuffer();
    }
}

