/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.classic;

public class MemoryLayout {
    private static final int FOUR_BLOCK_SECTORS = 32;
    private static final int SIXTEEN_BLOCK_SECTORS = 8;
    public static final MemoryLayout CLASSIC_1K = new MemoryLayout(16);
    public static final MemoryLayout CLASSIC_4K = new MemoryLayout(40);
    private int sectors;

    public MemoryLayout(int sectors) {
        this.sectors = sectors;
    }

    public int getMadVersion() {
        if (this.sectors == 16) {
            return 1;
        }
        return 2;
    }

    public int getSectors() {
        return this.sectors;
    }

    public int getBlocksPerSector(int sectorId) {
        if (sectorId < 32) {
            return 4;
        }
        return 16;
    }

    public int getDataBlocksPerSector(int sectorId) {
        if (sectorId < 32) {
            return 3;
        }
        return 15;
    }

    public int getBlockNumber(int sectorId, int blockId) {
        if (sectorId < 32) {
            return sectorId * 4 + blockId;
        }
        return 128 + ((sectorId - 32) * 16 + blockId);
    }

    public int getTrailerBlockNumberForSector(int sectorId) {
        return this.getBlocksPerSector(sectorId) - 1;
    }

    public boolean isTrailerBlock(int sectorId, int blockId) {
        return blockId == this.getBlocksPerSector(sectorId) - 1;
    }
}

