/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.classic;

import java.io.IOException;
import java.util.Arrays;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.KeyValue;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicConstants;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.Application;
import org.nfctools.utils.NfcUtils;

public class ClassicHandler {
    public static boolean isBlank(MfClassicReaderWriter readerWriter) throws IOException {
        try {
            MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
            for (int sector = 0; sector < memoryLayout.getSectors(); ++sector) {
                TrailerBlock trailerBlock = ClassicHandler.readTrailerBlock(readerWriter, sector, MfClassicConstants.TRANSPORT_KEY);
                if (!Arrays.equals(MfConstants.TRANSPORT_ACCESS_CONDITIONS, trailerBlock.getAccessConditions())) {
                    return false;
                }
                if (trailerBlock.getGeneralPurposeByte() == 105) continue;
                return false;
            }
            return true;
        }
        catch (MfLoginException e) {
            return false;
        }
    }

    public static boolean isFormattedWritable(Application application, KeyValue keyValue) throws IOException {
        try {
            TrailerBlock trailerBlock = application.readTrailer(keyValue);
            for (int dataArea = 0; dataArea < 3; ++dataArea) {
                if (trailerBlock.canWriteDataBlock(keyValue.getKey(), dataArea)) continue;
                return false;
            }
            return NfcUtils.getLeastSignificantNibble(trailerBlock.getGeneralPurposeByte()) == 0;
        }
        catch (MfLoginException e) {
            return false;
        }
    }

    public static TrailerBlock createReadWriteDataTrailerBlock() {
        try {
            TrailerBlock trailerBlock = new TrailerBlock();
            trailerBlock.setAccessConditions(MfConstants.NDEF_READ_WRITE_ACCESS_CONDITIONS);
            trailerBlock.setGeneralPurposeByte((byte)64);
            return trailerBlock;
        }
        catch (MfException e) {
            throw new RuntimeException(e);
        }
    }

    private static TrailerBlock readTrailerBlock(MfClassicReaderWriter readerWriter, int sector, KeyValue ... keys) throws IOException {
        MfLoginException lastException = null;
        for (KeyValue keyValue : keys) {
            try {
                MemoryLayout memoryLayout = readerWriter.getMemoryLayout();
                int trailerBlockNumberForSector = memoryLayout.getTrailerBlockNumberForSector(sector);
                MfClassicAccess access = new MfClassicAccess(keyValue, sector, trailerBlockNumberForSector);
                TrailerBlock trailerBlock = (TrailerBlock)readerWriter.readBlock(access)[0];
                return trailerBlock;
            }
            catch (MfLoginException e) {
                lastException = e;
            }
        }
        throw lastException;
    }
}

