/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.block;

import org.nfctools.mf.MfException;
import org.nfctools.mf.block.Block;
import org.nfctools.utils.NfcUtils;

public class ValueBlock
extends Block {
    private int value;
    private byte address;

    public ValueBlock(byte[] data) throws MfException {
        super(data, BLOCK_TYPE_VALUE);
        this.decypherValueBlock(data);
    }

    public ValueBlock(int value, byte address) {
        super(null, BLOCK_TYPE_VALUE);
        this.data = this.cypherValueBlock(value, address);
        this.value = value;
        this.address = address;
    }

    public static boolean isValidValueBlock(byte[] valueBlock) {
        for (int x = 0; x < 4; ++x) {
            if (valueBlock[x] == ~valueBlock[x + 4] && valueBlock[x] == valueBlock[x + 8]) continue;
            return false;
        }
        return valueBlock[12] == ~valueBlock[13] && valueBlock[12] == valueBlock[14] && valueBlock[13] == valueBlock[15];
    }

    public void decypherValueBlock(byte[] valueBlock) throws MfException {
        for (int x = 0; x < 4; ++x) {
            if (valueBlock[x] == ~valueBlock[x + 4] && valueBlock[x] == valueBlock[x + 8]) continue;
            throw new MfException("Not a valid value block. [" + NfcUtils.convertBinToASCII(valueBlock) + "]");
        }
        if (valueBlock[12] != ~valueBlock[13] || valueBlock[12] != valueBlock[14] || valueBlock[13] != valueBlock[15]) {
            throw new MfException("Not a valid value block. [" + NfcUtils.convertBinToASCII(valueBlock) + "]");
        }
        this.value = NfcUtils.bytesToInt(valueBlock, 0);
        this.address = valueBlock[12];
    }

    public byte[] cypherValueBlock(int value, byte address) {
        byte[] hexBin = NfcUtils.intTo4Bytes(value);
        byte[] bin = new byte[16];
        for (int x = 0; x < 4; ++x) {
            bin[x] = hexBin[x];
            bin[x + 4] = ~hexBin[x];
            bin[x + 8] = hexBin[x];
            bin[x + 12] = x % 2 == 0 ? address : (byte)(~address);
        }
        return bin;
    }

    public byte getAddress() {
        return this.address;
    }

    public void setAddress(byte address) {
        this.address = address;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }
}

