/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.block;

import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.block.Block;
import org.nfctools.mf.classic.Key;

public class TrailerBlock
extends Block {
    private static final int KEY_LENGTH = 6;
    private static final int KEY_A_INDEX = 0;
    private static final int KEY_B_INDEX = 10;
    private static final int GPB_INDEX = 9;
    private static final int ACCESS_CONDITIONS_INDEX = 6;

    public TrailerBlock() {
        super(new byte[16], BLOCK_TYPE_TRAIL);
        try {
            this.setAccessConditions(MfConstants.TRANSPORT_ACCESS_CONDITIONS);
            this.setKey(Key.A, MfConstants.TRANSPORT_KEY);
            this.setKey(Key.B, MfConstants.TRANSPORT_KEY);
            this.setGeneralPurposeByte((byte)105);
        }
        catch (MfException mfException) {
            // empty catch block
        }
    }

    public TrailerBlock(byte[] data) throws MfException {
        super(data, BLOCK_TYPE_TRAIL);
        if (!TrailerBlock.validAccessConditions(this.getAccessConditions())) {
            throw new MfException("illegal trailer block");
        }
    }

    public TrailerBlock clone() {
        try {
            byte[] cloneData = new byte[this.data.length];
            System.arraycopy(this.data, 0, cloneData, 0, this.data.length);
            return new TrailerBlock(cloneData);
        }
        catch (MfException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getKey(Key key) {
        byte[] keyValue = new byte[6];
        if (key == Key.A) {
            System.arraycopy(this.data, 0, keyValue, 0, 6);
        } else {
            System.arraycopy(this.data, 10, keyValue, 0, 6);
        }
        return keyValue;
    }

    public void setKey(Key key, byte[] keyValue) {
        if (key == Key.A) {
            System.arraycopy(keyValue, 0, this.data, 0, 6);
        } else {
            System.arraycopy(keyValue, 0, this.data, 10, 6);
        }
    }

    public byte getGeneralPurposeByte() {
        return this.data[9];
    }

    public void setGeneralPurposeByte(byte gpb) {
        this.data[9] = gpb;
    }

    public byte[] getAccessConditions() {
        byte[] acValue = new byte[3];
        System.arraycopy(this.data, 6, acValue, 0, acValue.length);
        return acValue;
    }

    public void setAccessConditions(byte[] acValue) throws MfException {
        if (!TrailerBlock.validAccessConditions(acValue)) {
            throw new MfException("illegal access conditions");
        }
        System.arraycopy(acValue, 0, this.data, 6, acValue.length);
    }

    public static boolean validAccessConditions(byte[] acValue) {
        if (acValue.length != 3) {
            return false;
        }
        if (((acValue[0] ^ 0xF0) >>> 4 & 0xF) != (acValue[2] & 0xF)) {
            return false;
        }
        if (((acValue[0] ^ 0xF) & 0xF) != (acValue[1] >>> 4 & 0xF)) {
            return false;
        }
        return ((acValue[1] ^ 0xF) & 0xF) == (acValue[2] >>> 4 & 0xF);
    }

    public boolean isKeyBReadable() {
        int accessBits = this.extractAccesBitsForBlock(3);
        return accessBits == 0 || accessBits == 1 || accessBits == 2;
    }

    public boolean canWriteDataBlock(Key key, int dataArea) {
        int accessBits = this.extractAccesBitsForBlock(dataArea);
        if (Key.A.equals((Object)key)) {
            return accessBits == 0;
        }
        return accessBits == 4 || accessBits == 3 || accessBits == 6 || accessBits == 0 && !this.isKeyBReadable();
    }

    public boolean canWriteTrailerBlock(Key key) {
        int accessBits = this.extractAccesBitsForBlock(3);
        if (Key.A.equals((Object)key)) {
            return accessBits == 1;
        }
        return accessBits == 3;
    }

    private int extractAccesBitsForBlock(int blockId) {
        int accessBits = (this.data[6] >> blockId & 1) << 2;
        accessBits |= (this.data[8] >> blockId & 1) << 1;
        int bitC2 = (accessBits |= this.data[7] >> blockId & 1) & 2;
        int inverted = accessBits ^ 7;
        return inverted & 5 | bitC2;
    }
}

