/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.mf.block;

import org.nfctools.mf.block.MfBlock;
import org.nfctools.utils.NfcUtils;

public abstract class Block
implements MfBlock {
    public static int BLOCK_TYPE_VALUE = 0;
    public static int BLOCK_TYPE_DATA = 1;
    public static int BLOCK_TYPE_MANU = 2;
    public static int BLOCK_TYPE_TRAIL = 3;
    private static String[] typeNames = new String[]{"Value", "Data ", "Manu ", "Trail"};
    protected byte[] data;
    private int type;

    protected Block(byte[] data, int type) {
        this.type = type;
        if (data != null) {
            this.data = data.length == 16 ? data : NfcUtils.convertASCIIToBin(new String(data));
        }
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "[" + typeNames[this.getType()] + "] [" + NfcUtils.convertBinToASCII(this.data) + "]";
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public boolean isDataBlock() {
        return this.type == BLOCK_TYPE_DATA;
    }
}

