/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.llcp;

import java.io.IOException;
import org.nfctools.llcp.LlcpConnectionManager;
import org.nfctools.llcp.LlcpConnectionManagerFactory;
import org.nfctools.llcp.pdu.AbstractProtocolDataUnit;
import org.nfctools.llcp.pdu.PduDecoder;
import org.nfctools.llcp.pdu.Symmetry;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;

public class LlcpOverNfcip
implements NFCIPConnectionListener {
    private PduDecoder pduDecoder = new PduDecoder();
    private LlcpConnectionManagerFactory connectionManagerFactory;

    public LlcpOverNfcip(LlcpConnectionManagerFactory connectionManagerFactory) {
        this.connectionManagerFactory = connectionManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnection(NFCIPConnection connection) throws IOException {
        LlcpConnectionManager connectionManager = this.connectionManagerFactory.createInstance();
        connectionManager.init(this.extractParameters(connection.getGeneralBytes()));
        try {
            byte[] data;
            byte[] byArray = data = connection.isInitiator() ? this.pduDecoder.encode(new Symmetry()) : connection.receive();
            while (!Thread.interrupted()) {
                AbstractProtocolDataUnit requestPdu = this.pduDecoder.decode(data);
                AbstractProtocolDataUnit responsePdu = requestPdu.processPdu(connectionManager);
                byte[] pdu = this.pduDecoder.encode(responsePdu);
                connection.send(pdu);
                data = connection.receive();
            }
        }
        finally {
            connectionManager.clearConnections();
        }
    }

    public Object[] extractParameters(byte[] generalBytes) {
        if (generalBytes.length >= 3 && generalBytes[0] == 70 && generalBytes[1] == 102 && generalBytes[2] == 109) {
            return this.pduDecoder.decodeParameter(generalBytes, 3);
        }
        return new Object[0];
    }
}

