/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.io;

import java.io.IOException;
import java.io.OutputStream;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayOutputStreamWriter
implements ByteArrayWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private OutputStream outputStream;

    public ByteArrayOutputStreamWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(NfcUtils.convertBinToASCII(data, offset, length));
        }
        this.outputStream.write(data, offset, length);
    }
}

