/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.io;

import java.io.IOException;
import java.io.InputStream;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayInputStreamReader
implements ByteArrayReader {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private InputStream inputStream;

    public ByteArrayInputStreamReader(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public void setTimeout(long millis) {
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        int dataRead = this.inputStream.read(data, offset, length);
        if (this.log.isDebugEnabled() && dataRead > 0) {
            this.log.debug("[" + NfcUtils.convertBinToASCII(data, offset, dataRead) + "]");
        }
        return dataRead;
    }
}

