/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.snep;

import java.io.IOException;
import org.nfctools.NfcAdapter;
import org.nfctools.examples.TerminalUtils;
import org.nfctools.examples.snep.SnepAgentListenterImpl;
import org.nfctools.llcp.LlcpConnectionManager;
import org.nfctools.llcp.LlcpConnectionManagerFactory;
import org.nfctools.llcp.LlcpOverNfcip;
import org.nfctools.scio.Terminal;
import org.nfctools.scio.TerminalMode;
import org.nfctools.snep.SnepClient;
import org.nfctools.snep.SnepServer;
import org.nfctools.utils.LoggingNdefListener;

public class SnepDemo {
    private LlcpOverNfcip llcpOverNfcip;
    private SnepClient snepClient;

    public SnepDemo() {
        LoggingNdefListener loggingNdefListener = new LoggingNdefListener();
        final SnepServer snepServer = new SnepServer(loggingNdefListener);
        this.snepClient = new SnepClient();
        this.llcpOverNfcip = new LlcpOverNfcip(new LlcpConnectionManagerFactory(){

            @Override
            protected void configureConnectionManager(LlcpConnectionManager connectionManager) {
                connectionManager.registerServiceAccessPoint(4, snepServer);
                connectionManager.registerServiceAccessPoint(SnepDemo.this.snepClient);
            }
        });
    }

    public void addUrlToSend(String url) {
        this.snepClient.setSnepAgentListener(new SnepAgentListenterImpl(url));
    }

    public void runDemo(boolean initiatorMode, String preferredTerminalName) throws IOException {
        TerminalMode terminalMode = initiatorMode ? TerminalMode.INITIATOR : TerminalMode.TARGET;
        Terminal terminal = TerminalUtils.getAvailableTerminal(preferredTerminalName);
        System.out.println("Using: " + terminal.getTerminalName());
        NfcAdapter nfcAdapter = new NfcAdapter(terminal, terminalMode);
        nfcAdapter.setNfcipConnectionListener(this.llcpOverNfcip);
        nfcAdapter.startListening();
        System.out.println("Mode: " + (Object)((Object)terminalMode));
        System.out.println("Waiting for P2P, press ENTER to exit");
        System.in.read();
    }

    private static String findParam(String name, String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (!("-" + name).equals(args[x])) continue;
            return args[x + 1];
        }
        return null;
    }

    private static boolean isTargetMode(String[] args) {
        for (int x = 0; x < args.length; ++x) {
            if (!args[x].equals("-target")) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            boolean targetMode = SnepDemo.isTargetMode(args);
            String preferredTerminalName = SnepDemo.findParam("terminal", args);
            SnepDemo demo = new SnepDemo();
            String url = SnepDemo.findParam("url", args);
            if (url != null) {
                demo.addUrlToSend(url);
            }
            demo.runDemo(!targetMode, preferredTerminalName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

