/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.snep;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.records.UriRecord;
import org.nfctools.snep.PutResponseListener;
import org.nfctools.snep.SnepAgent;
import org.nfctools.snep.SnepAgentListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnepAgentListenterImpl
implements SnepAgentListener,
PutResponseListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<Record> records = new ArrayList<Record>();

    public SnepAgentListenterImpl(String url) {
        this.records.add(new UriRecord(url));
    }

    @Override
    public void onSnepConnection(SnepAgent snepAgent) {
        if (!this.records.isEmpty()) {
            this.log.info("SNEP connection available, sending message...");
            snepAgent.doPut(new ArrayList<Record>(this.records), this);
            this.records.clear();
        }
    }

    @Override
    public boolean hasDataToSend() {
        return !this.records.isEmpty();
    }

    @Override
    public void onSuccess() {
        this.log.info("SNEP succeeded");
        this.records.clear();
    }

    @Override
    public void onFailed() {
        this.log.info("SNEP failed");
    }
}

