/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.nfcip;

import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfcTarget
implements Runnable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NFCIPManager nfcipManager;

    public NfcTarget(NFCIPManager nfcipManager) {
        this.nfcipManager = nfcipManager;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.log.info("Waiting for connection");
                NFCIPConnection nfcipConnection = this.nfcipManager.connectAsTarget();
                this.log.info("Connected, waiting for data...");
                byte[] data = null;
                int runs = 0;
                do {
                    this.log.trace("Start of Run: " + runs);
                    data = nfcipConnection.receive();
                    this.log.info("Received: " + data.length + " Runs: " + runs);
                    nfcipConnection.send(data);
                    this.log.trace("End of Run: " + runs);
                    ++runs;
                } while (data != null && data.length > 0);
                this.log.info("DONE!!!");
                this.log.info("Closing connection");
                nfcipConnection.close();
                Thread.sleep(500L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return;
        }
    }
}

