/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.nfcip;

import java.text.DecimalFormat;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfcInitiator
implements Runnable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DecimalFormat df = new DecimalFormat("#.###");
    private NFCIPManager nfcipManager;
    private final int RUNS = 5;

    public NfcInitiator(NFCIPManager nfcipManager) {
        this.nfcipManager = nfcipManager;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.log.info("Waiting for connection");
                NFCIPConnection nfcipConnection = this.nfcipManager.connectAsInitiator();
                this.log.info("Connected, sending data...");
                long time = System.currentTimeMillis();
                int totalSend = 0;
                byte[] data = new byte[200];
                for (int k = 0; k < data.length; ++k) {
                    data[k] = (byte)(255 - k);
                }
                for (int runs = 0; runs < 5; ++runs) {
                    this.log.trace("Start of Run: " + runs);
                    nfcipConnection.send(data);
                    totalSend += data.length;
                    this.log.info("Send: " + data.length + " Runs: " + runs);
                    byte[] receive = nfcipConnection.receive();
                    this.log.info("Response: " + receive.length);
                    this.log.trace("End of Run: " + runs);
                }
                nfcipConnection.send(new byte[0]);
                nfcipConnection.receive();
                double timeNeeded = (double)(System.currentTimeMillis() - time) / 1000.0;
                this.log.info("DONE in " + timeNeeded + "sec, " + this.df.format((double)totalSend / 1024.0 / timeNeeded) + " kb/s");
                this.log.info("Closing connection");
                nfcipConnection.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

