/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.ndefwriter;

import java.io.IOException;
import org.nfctools.examples.TerminalUtils;
import org.nfctools.examples.ndef.NdefExampleRecords;
import org.nfctools.io.NfcDevice;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.ndef.MfNdefWriter;
import org.nfctools.ndef.NdefContext;
import org.nfctools.ndef.NdefException;
import org.nfctools.spi.acs.Acr122ReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdefWriterDemo
implements MfCardListener {
    private static Logger log = LoggerFactory.getLogger(NdefWriterDemo.class.getName());
    private NfcDevice nfcReaderWriter = TerminalUtils.getAvailableTerminal();
    private MfReaderWriter readerWriter = new Acr122ReaderWriter(this.nfcReaderWriter);
    private MfNdefWriter ndefWriter = new MfNdefWriter(this.readerWriter, NdefContext.getNdefMessageEncoder());

    @Override
    public void cardDetected(MfCard card, MfReaderWriter readerWriter) throws IOException {
        log.info("Card found. " + card);
        long time = System.currentTimeMillis();
        try {
            this.ndefWriter.writeNdefMessage(card, NdefExampleRecords.convertToList(NdefExampleRecords.createWifiSetting()));
        }
        catch (NdefException e) {
            log.error(e.getMessage(), e);
        }
        log.info("All done in: " + (System.currentTimeMillis() - time) + "ms");
        System.exit(0);
    }

    public void runNdefWriter() {
        try {
            this.nfcReaderWriter.open();
            log.info("Listening...");
            this.readerWriter.setCardListener(this);
            System.in.read();
            this.nfcReaderWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            NdefWriterDemo demo = new NdefWriterDemo();
            demo.runNdefWriter();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

