/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.ndefreader;

import java.io.IOException;
import java.util.List;
import org.nfctools.examples.TerminalUtils;
import org.nfctools.io.NfcDevice;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.ndef.MfNdefReader;
import org.nfctools.ndef.NdefContext;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.Record;
import org.nfctools.spi.acs.Acr122ReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NdefReaderDemo
implements MfCardListener {
    private static Logger log = LoggerFactory.getLogger(NdefReaderDemo.class.getName());
    private NfcDevice nfcReaderWriter = TerminalUtils.getAvailableTerminal();
    private MfReaderWriter readerWriter = new Acr122ReaderWriter(this.nfcReaderWriter);
    private NdefMessageDecoder decoder = NdefContext.getNdefMessageDecoder();

    @Override
    public void cardDetected(MfCard card, MfReaderWriter readerWriter) throws IOException {
        MfNdefReader ndefReader = new MfNdefReader(readerWriter, this.decoder);
        try {
            List<Record> records = ndefReader.readNdefMessage(card);
            for (Record record : records) {
                log.info(record.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runNdefReader() {
        try {
            this.nfcReaderWriter.open();
            log.info("Listening...");
            this.readerWriter.setCardListener(this);
            log.info("Done");
            System.in.read();
            this.nfcReaderWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            NdefReaderDemo demo = new NdefReaderDemo();
            demo.runNdefReader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

