/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.llcp;

import java.util.ArrayList;
import java.util.Collection;
import org.nfctools.llcp.LlcpConnectionManager;
import org.nfctools.llcp.LlcpConnectionManagerFactory;
import org.nfctools.llcp.LlcpOverNfcip;
import org.nfctools.ndef.NdefListener;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.records.UriRecord;
import org.nfctools.ndefpush.NdefPushFinishListener;
import org.nfctools.ndefpush.NdefPushLlcpService;
import org.nfctools.scio.Terminal;
import org.nfctools.scio.TerminalHandler;
import org.nfctools.scio.TerminalStatusListener;
import org.nfctools.snep.SnepClient;
import org.nfctools.snep.SnepServer;
import org.nfctools.spi.acs.AcsTerminal;
import org.nfctools.spi.scm.SclTerminal;
import org.nfctools.utils.LoggingNdefListener;
import org.nfctools.utils.LoggingStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlcpService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NdefListener ndefListener;
    private NdefPushLlcpService ndefPushLlcpService;
    private Terminal terminal;
    private boolean initiatorMode = false;

    public LlcpService(NdefListener ndefListener, TerminalStatusListener statusListener) {
        this.ndefListener = ndefListener;
        TerminalHandler terminalHandler = new TerminalHandler();
        terminalHandler.addTerminal(new AcsTerminal());
        terminalHandler.addTerminal(new SclTerminal());
        this.terminal = terminalHandler.getAvailableTerminal();
        this.terminal.setStatusListener(statusListener);
        this.terminal.setNdefListener(ndefListener);
        this.log.info("Connected to " + this.terminal.getTerminalName());
    }

    public void addMessages(Collection<Record> ndefRecords, NdefPushFinishListener finishListener) {
        this.ndefPushLlcpService.addMessages(ndefRecords, finishListener);
    }

    public String getTerminalName() {
        return this.terminal.getTerminalName();
    }

    public void run() {
        final SnepServer snepServer = new SnepServer(new LoggingNdefListener());
        final SnepClient snepClient = new SnepClient();
        this.ndefPushLlcpService = new NdefPushLlcpService(this.ndefListener);
        LlcpOverNfcip llcpOverNfcip = new LlcpOverNfcip(new LlcpConnectionManagerFactory(){

            @Override
            protected void configureConnectionManager(LlcpConnectionManager connectionManager) {
                connectionManager.registerWellKnownServiceAccessPoint("com.android.npp", LlcpService.this.ndefPushLlcpService);
                connectionManager.registerServiceAccessPoint(4, snepServer);
                connectionManager.registerServiceAccessPoint(snepClient);
            }
        });
        try {
            this.terminal.setNfcipConnectionListener(llcpOverNfcip);
            if (this.initiatorMode) {
                this.terminal.initInitiatorDep();
            } else {
                this.terminal.initTargetDep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run2() {
        this.ndefPushLlcpService = new NdefPushLlcpService(this.ndefListener);
        String content = "http://www.google.de";
        final ArrayList<Record> records = new ArrayList<Record>();
        records.add(new UriRecord(content));
        this.addMessages(records, new NdefPushFinishListener(){

            @Override
            public void onNdefPushFinish() {
                System.out.println("sent");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(1000L);
                            System.out.println("\n\n\nAdding new records...");
                            LlcpService.this.addMessages(records, null);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }).start();
            }

            @Override
            public void onNdefPushFailed() {
            }
        });
        LlcpOverNfcip llcpOverNfcip = new LlcpOverNfcip(new LlcpConnectionManagerFactory(){

            @Override
            protected void configureConnectionManager(LlcpConnectionManager connectionManager) {
                connectionManager.registerWellKnownServiceAccessPoint("com.android.npp", LlcpService.this.ndefPushLlcpService);
            }
        });
        try {
            this.terminal.setNfcipConnectionListener(llcpOverNfcip);
            if (this.initiatorMode) {
                this.terminal.initInitiatorDep();
            } else {
                this.terminal.initTargetDep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LlcpService service = new LlcpService(new LoggingNdefListener(), new LoggingStatusListener());
        service.run2();
    }
}

