/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.examples.llcp;

import java.io.IOException;
import java.util.Collection;
import org.nfctools.NfcAdapter;
import org.nfctools.examples.TerminalUtils;
import org.nfctools.llcp.LlcpConnectionManager;
import org.nfctools.llcp.LlcpConnectionManagerFactory;
import org.nfctools.llcp.LlcpOverNfcip;
import org.nfctools.ndef.Record;
import org.nfctools.ndefpush.NdefPushFinishListener;
import org.nfctools.ndefpush.NdefPushLlcpService;
import org.nfctools.scio.TerminalMode;
import org.nfctools.utils.LoggingNdefListener;

public class LlcpDemo {
    private NdefPushLlcpService ndefPushLlcpService;
    private boolean initiatorMode;
    private LlcpOverNfcip llcpOverNfcip;

    public LlcpDemo(boolean initiatorMode) {
        this.initiatorMode = initiatorMode;
        this.ndefPushLlcpService = new NdefPushLlcpService(new LoggingNdefListener());
        this.llcpOverNfcip = new LlcpOverNfcip(new LlcpConnectionManagerFactory(){

            @Override
            protected void configureConnectionManager(LlcpConnectionManager connectionManager) {
                connectionManager.registerWellKnownServiceAccessPoint("com.android.npp", LlcpDemo.this.ndefPushLlcpService);
            }
        });
    }

    public void addMessages(Collection<Record> ndefRecords, NdefPushFinishListener finishListener) {
        this.ndefPushLlcpService.addMessages(ndefRecords, finishListener);
    }

    public void runDemo() throws IOException {
        TerminalMode terminalMode = this.initiatorMode ? TerminalMode.INITIATOR : TerminalMode.TARGET;
        NfcAdapter nfcAdapter = new NfcAdapter(TerminalUtils.getAvailableTerminal(), terminalMode);
        nfcAdapter.setNfcipConnectionListener(this.llcpOverNfcip);
        nfcAdapter.startListening();
        System.out.println("Mode: " + (Object)((Object)terminalMode));
        System.out.println("Waiting for P2P, press ENTER to exit");
        System.in.read();
    }

    public static void main(String[] args) {
        try {
            boolean targetMode = args.length == 1 && args[0].equals("-target");
            LlcpDemo service = new LlcpDemo(!targetMode);
            service.runDemo();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

