/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.com;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.nfctools.com.AbstractBaudRateNegotiator;
import org.nfctools.com.InputOutputToken;
import org.nfctools.com.SerialPortEventListenerImpl;
import org.nfctools.io.NfcDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialPortNfcDevice
implements NfcDevice {
    private static final int TIMEOUT_FOR_OPEN = 1000;
    private static final int SERIAL_PORT_BUFFER_SIZE = 1024;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SerialPort port = null;
    private AbstractBaudRateNegotiator speedNegotiator;
    private InputOutputToken inputOutputToken = new InputOutputToken();
    private int baudRate;
    private String comPort;

    public SerialPortNfcDevice(AbstractBaudRateNegotiator speedNegotiator) {
        this.speedNegotiator = speedNegotiator;
    }

    @Override
    public InputOutputToken getConnectionToken() {
        return this.inputOutputToken;
    }

    @Override
    public void close() throws IOException {
        this.inputOutputToken.close();
        this.port.close();
        this.port = null;
    }

    @Override
    public void open() throws IOException {
        if (this.port == null) {
            try {
                CommPortIdentifier identifier = this.findCommPortIdentifier(this.comPort);
                if (identifier == null) {
                    throw new RuntimeException("ComPort not found: " + this.comPort);
                }
                this.port = (SerialPort)identifier.open(SerialPortNfcDevice.class.getName() + "." + this.comPort, 1000);
                this.port.setInputBufferSize(1024);
                this.log.trace(this.port + " BaudRate: " + this.port.getBaudRate() + ", InputBuffer: " + this.port.getInputBufferSize());
                this.tweakPort();
                this.inputOutputToken.setInputStream(this.port.getInputStream());
                this.inputOutputToken.setOutputStream(this.port.getOutputStream());
                this.speedNegotiator.negotiateBaudRateOnObject(this.port, this.baudRate);
                this.log.trace("Comport opened: " + this.port + " BaudRate: " + this.port.getBaudRate() + ", InputBuffer: " + this.port.getInputBufferSize());
            }
            catch (PortInUseException e) {
                throw new IOException(e);
            }
        }
    }

    private void initSerialPortEventListener() throws IOException {
        try {
            this.port.addEventListener((SerialPortEventListener)new SerialPortEventListenerImpl());
            this.port.notifyOnDataAvailable(true);
        }
        catch (TooManyListenersException e) {
            throw new IOException(e);
        }
    }

    private void tweakPort() {
        try {
            this.port.enableReceiveThreshold(1);
            this.port.enableReceiveTimeout(10);
        }
        catch (UnsupportedCommOperationException e) {
            throw new RuntimeException(e);
        }
        this.log.trace("ReceiveThreshold: " + this.port.getReceiveThreshold() + " ReceiveTimeout: " + this.port.getReceiveTimeout() + " enabled: " + this.port.isReceiveTimeoutEnabled() + " DataBits: " + this.port.getDataBits() + " StopBits: " + this.port.getStopBits() + " Parity: " + this.port.getParity());
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    public String getComPort() {
        return this.comPort;
    }

    public void setComPort(String comPort) {
        this.comPort = comPort;
    }

    private CommPortIdentifier findCommPortIdentifier(String name) {
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        CommPortIdentifier port = null;
        while (enumeration.hasMoreElements()) {
            CommPortIdentifier identifier = (CommPortIdentifier)enumeration.nextElement();
            if (!identifier.getName().equalsIgnoreCase(name)) continue;
            port = identifier;
        }
        return port;
    }
}

