/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.com;

import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaudRateNegotiator {
    protected static final int TIMEOUT = 1000;
    protected static final int BUFFER_SIZE = 1024;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected SerialPort port = null;
    protected InputStream in = null;
    protected OutputStream out = null;
    public static final int BAUDRATE_9600 = 9600;
    public static final int BAUDRATE_115200 = 115200;
    public static final int BAUDRATE_460800 = 460800;
    protected int[] knownBaudRates = new int[]{9600, 115200, 460800};

    public abstract void negotiateBaudRateOnObject(SerialPort var1, int var2) throws IOException;

    protected abstract boolean checkPortBaudRate() throws IOException;

    protected String readResponse() throws IOException {
        this.waitForData();
        byte[] buffer = new byte[1024];
        int pos = 0;
        while (this.in.available() > 0 && pos < buffer.length) {
            pos += this.in.read(buffer, pos, buffer.length - pos);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        String resp = new String(buffer, 0, pos);
        this.log.debug("bytes received: " + pos + " => " + resp);
        return resp;
    }

    protected void clearInputBuffers() {
        byte[] buffer = new byte[1024];
        int bytesCleared = 0;
        try {
            while (this.in.available() > 0) {
                bytesCleared += this.in.read(buffer, 0, buffer.length);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.log.debug(bytesCleared + " bytes cleared");
    }

    protected void findoutCurrentBaudRate() throws IOException {
        if (this.checkPortBaudRate()) {
            this.log.trace("Current baud rate was default");
            return;
        }
        for (int baudRate : this.knownBaudRates) {
            this.clearInputBuffers();
            this.log.debug("Probing baud rate " + baudRate);
            this.setSerialPortParams(baudRate);
            if (!this.checkPortBaudRate()) continue;
            this.log.trace("Current baud rate was " + baudRate);
            return;
        }
        throw new RuntimeException("cannot identify current baud rate");
    }

    protected void sendASCIIMessage(String s) throws IOException {
        this.log.debug(s);
        this.out.write(s.getBytes());
    }

    protected void setSerialPortParams(int baudRate) {
        this.log.debug("Setting com port baud rate to " + baudRate);
        try {
            this.port.setSerialPortParams(baudRate, 8, 1, 0);
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {}
        }
        catch (UnsupportedCommOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForData() throws IOException {
        try {
            for (int counter = 0; this.in.available() == 0 && counter < 1000; ++counter) {
                Thread.sleep(1L);
            }
            if (this.in.available() == 0) {
                throw new IOException("Timeout. No data received.");
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
    }
}

