/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.api.NfcTagListener;
import org.nfctools.api.Tag;
import org.nfctools.api.TagListener;
import org.nfctools.api.UnknownTagListener;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.scio.Terminal;
import org.nfctools.scio.TerminalMode;

public class NfcAdapter
implements TagListener {
    private Terminal terminal;
    private List<NfcTagListener> nfcTagListeners = new ArrayList<NfcTagListener>();
    private UnknownTagListener unknownTagListener = new UnknownTagListener(){

        @Override
        public void unsupportedTag(Tag tag) {
        }
    };

    public NfcAdapter(Terminal terminal, TerminalMode terminalMode) {
        this.terminal = terminal;
        this.setMode(terminalMode);
        terminal.registerTagListener(this);
    }

    public void setNfcipConnectionListener(NFCIPConnectionListener nfcipConnectionListener) {
        this.terminal.setNfcipConnectionListener(nfcipConnectionListener);
    }

    public void registerTagListener(NfcTagListener nfcTagListener) {
        this.nfcTagListeners.add(nfcTagListener);
    }

    public void registerUnknownTagListerner(UnknownTagListener unknownTagListener) {
        this.unknownTagListener = unknownTagListener;
    }

    public void setMode(TerminalMode terminalMode) {
        this.terminal.setMode(terminalMode);
    }

    public void startListening() {
        this.terminal.startListening();
    }

    public void stopListening() {
        this.terminal.stopListening();
    }

    @Override
    public void onTag(Tag tag) {
        boolean handlerFound = false;
        for (NfcTagListener nfcTagListener : this.nfcTagListeners) {
            try {
                if (!nfcTagListener.canHandle(tag)) continue;
                nfcTagListener.handleTag(tag);
                handlerFound = true;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!handlerFound) {
            this.unknownTagListener.unsupportedTag(tag);
        }
    }
}

